﻿#ifndef _SDK_COMMON_API_H
#define _SDK_COMMON_API_H

#ifdef LINUX
    #define SDK_API __attribute__ ( (visibility( "default" ) ) )
    #define CALL_STACK
    #define TCHAR char
#else
    //#include <tchar.h>

	#ifdef EXPORT_CDECL
	#define CALL_STACK __cdecl
	#else
	#define CALL_STACK __stdcall
	#endif

    #ifndef SDK_API
    #ifdef __cplusplus
    #define SDK_API extern "C" //__declspec( dllexport )  --- 鶨.
    #else
    #define SDK_API //__declspec( dllexport )
    #endif
    #endif
#endif

SDK_API void CALL_STACK FormatError( int errorNo, int langid, unsigned char* buf, int pos, int bufSize );

SDK_API int CALL_STACK PrinterCreator( void** phandle, const char* model );

SDK_API int CALL_STACK SetLog(int enable, const char* path);

SDK_API void* CALL_STACK PrinterCreatorS( char* model );

SDK_API int CALL_STACK PrinterDestroy( void* handle );

SDK_API int CALL_STACK PortOpen( void* handle, const char* ioSettings );

SDK_API int CALL_STACK DriverPortOpen( void* handle, const char* driverName );

SDK_API int CALL_STACK PortClose( void* handle );

SDK_API int CALL_STACK DirectIO( void* handle, unsigned char* writedata, unsigned int writeNum, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum );

SDK_API int CALL_STACK WriteData( void* handle, unsigned char* writeData, unsigned int writeNum );

SDK_API int CALL_STACK ReadData( void* handle, unsigned char* readData, unsigned int readNum, unsigned int* preadedNum );

SDK_API int CALL_STACK ReadDataEOF( void* handle, unsigned char* readData, unsigned int offSet, unsigned int bufLength, unsigned char soh, unsigned char eof, unsigned int* preadedNum );

SDK_API int CALL_STACK SendCommand( void* handle, char* writedata);

//add by wjz 20230216 获取设备连接信息 
SDK_API int CALL_STACK GetUriOption(void* handle, char* key, char* value, int buflen);

#endif
